*** rt-hazrate.do
*** v1.1
clear all
set more off
set type double

use rt-E.dta, clear
merge 1:1 mdate using rt-U.dta, nogen
merge 1:1 mdate using rt-U_s.dta, nogen

keep if mdate>=tm(1949m1)

cap erase rt-hazrate.dta

unab foo: U_s_*
local rdatelist: subinstr local foo "U_s_" "", all
local i = 1
preserve
foreach rdate of local rdatelist {
  noi disp %tm `rdate'
  restore, preserve
  gen E = E_`rdate'
  gen U = U_`rdate'
  gen U_s = U_s_`rdate'
  sum mdate if E_`rdate'!=.
  outsheet mdate E U U_s if mdate<=r(max) using foo.csv, comma replace nonames
  !echo "E U U_S" > input.csv
  !cat foo.csv >> input.csv
  !rats rt-hazrate.prg rt-hazrate.out
  insheet using output.csv, comma clear
  gen int mdate=tm(1949m1)+_n-1
  drop v1
  order mdate
  keep mdate s f
  rename f f_`rdate'
  rename s s_`rdate'
  if `i'>1 {
    merge 1:1 mdate using rt-hazrate.dta, nogen
  }
  compress
  save rt-hazrate.dta, replace
  local i=`++i'
}
restore, not

erase foo.csv
erase input.csv
erase output.csv
